dofile(LockOn_Options.script_path.."Gunsight_K14/Indicator/K14_definitions.lua")

dbgDraw = false

-- texture pixels
tex_units_k14_X = 1.0 / 512
tex_units_k14_Y = tex_units_k14_X

tex_scale_k14_X = tex_units_k14_X * 3.2821
tex_scale_k14_Y = tex_scale_k14_X

FIXED_CROSS = 0 
FIXED_RING = 1
GYRO_SIGHT = 2

fixed_cross = AddHUDK14TexElement("fixed_Cross", 
				{{-5, -5}, {-5, 5}, 
				{5, 5}, {5, -5}},
				{tex_units_k14_X * 295, tex_units_k14_Y * 19, tex_scale_k14_X, tex_scale_k14_Y},
				{{"K14_draw_sights", FIXED_CROSS}, {"K14_fixedSightLightness"}},
				{0.0, ZSL, 0.0},
				{0.0, 0.0, 0.0},
				nil,
				HUD_DEFAULT_LEVEL )
fixed_cross.isdraw = true

fixed_reticle = AddHUDK14TexElement("fixed_reticle", 
				{{-36.5, -42}, {-36.5, 35.7}, 
				{36.5, 35.7}, {36.5, -42}},
				{tex_units_k14_X * 131, tex_units_k14_Y * 121, tex_scale_k14_X, tex_scale_k14_Y},
				{{"K14_draw_sights", FIXED_RING}, {"K14_fixedSightLightness"}},
				{0.0, ZSL, 0.0},
				{0.0, 0.0, 0.0},
				nil,
				HUD_DEFAULT_LEVEL )
fixed_reticle.isdraw = true

AddHUDK14TexElement("2_mils_pipper", 
				{{-2, -2}, {-2, 2}, 
				{2, 2}, {2, -2}},
				{tex_units_k14_X * 262, tex_units_k14_Y * 19, tex_scale_k14_X, tex_scale_k14_Y},
				{{"K14_draw_sights",GYRO_SIGHT}, {"K14_movableSightLightness"}, {"K14_gyro_sight_pos"}},
				{0.0, ZSL, 0.0},
				{0.0, 0.0, 0.0},
				nil,
				HUD_DEFAULT_LEVEL)
			
SpanMaskSizeXmax = 61
SpanMaskSizeXmin = 7
SpanMaskSizeX_Bottom = -1.587
SpanMaskSizeX_Top = 0.0

function addSpanMask(name, clipLevel, clipRelation)
	--angle = 0 -- DBG
	for angle=0, 300, 60 do
		local maskline 			= CreateElement "ceMeshPoly"
		maskline.name			= name..angle
		maskline.primitivetype  = "triangles"
		maskline.vertices		= {{SpanMaskSizeXmin + 2, SpanMaskSizeX_Bottom},
								 {SpanMaskSizeXmin - 1, SpanMaskSizeX_Top},
								 {SpanMaskSizeXmax, SpanMaskSizeX_Top},
								 {SpanMaskSizeXmax, SpanMaskSizeX_Bottom}
								}
		maskline.indices		= default_box_indices
		maskline.init_pos		= {0, 0, 0}
		maskline.init_rot		= {angle + 90, 0, 0}
		maskline.material		= "DBG_RED"
		if not dbgDraw then
			maskline.h_clip_relation = clipRelation
			maskline.level			= clipLevel
		end
		maskline.controllers	= {{"K14_rotateSpanMask"}}
		maskline.isvisible		= dbgDraw
		maskline.collimated		= true
		maskline.parent_element = "2_mils_pipper"
		Add(maskline)
	end
end

addSpanMask("spanMaskClip", HUD_DEFAULT_LEVEL, h_clip_relations.INCREASE_IF_LEVEL)

-- old
--[[
for angle = 0,300,60 do
Range_Graticule_leaf1 = AddHUDK14TexElement("K14_leaf1"..angle, 
				{{0.0, 1}, {0.0, -67}, {82, -67}, {82, 1}},
				{tex_units_k14_X * 13, tex_units_k14_Y * 276, tex_scale_k14_X, tex_scale_k14_Y},
				{{"K14_rotateRangeMask"}},
				{0.0, 0.0, 0.0},
				{angle , 0.0, 0.0},
				"2_mils_pipper",
				HUD_DEFAULT_LEVEL)
				--HUD_DEFAULT_LEVEL + 1)

				Range_Graticule_leaf1.isdraw = true
end
--]]

function Arg_D(Arg)
	return kD * math.log(Arg) + bD
end

function Arg_L(Arg)
	return kL * math.log(Arg) + bL
end

function Rel_Angle(L, D)
	return K_ang_L * Arg_L(L) - K_ang_D * Arg_D(D)
end

dmin_mrad = Lmin / Dmax
dmax_mrad = Lmin / Dmin2

Ang_Bias = Rel_Angle(Lmin, Dmax)
D_mask_angle_max = Rel_Angle(Lmin, Dmin2) - Ang_Bias

--dbg_print(string.format("D_mask_angle_max %g\n", D_mask_angle_max)) 

b = dmin_mrad / 2
k = (1 / D_mask_angle_max) * math.log(dmax_mrad / 2 / b)

rangePoints = {}
A = 0
iterations = 10
rangePtsK = 1000
delta = D_mask_angle_max / iterations
for i = 1, iterations + 1 do
	angle = A - D_mask_angle_max
	R = b * math.exp(k * A)
	rangePoints[i] = {math.sin(angle) * R * rangePtsK - 0.7, math.cos(angle) * R * rangePtsK}
	A = A + delta
end

-- new
--angle = 0 -- DBG
for angle = 0, 300, 60 do
	local rangeMaskPart			 	= CreateElement "ceSimpleLineObject"
	rangeMaskPart.indices		 	= default_box_indices
	rangeMaskPart.material		 	= "INDICATION_K14"
	rangeMaskPart.name			 	= "rangeMaskPart_"..angle
	rangeMaskPart.vertices		 	= rangePoints
	rangeMaskPart.tex_params 	 	= {{tex_units_k14_X * 305, tex_units_k14_Y * 54}, {tex_units_k14_X * 305, tex_units_k14_Y * 488},
		{tex_scale_k14_X, tex_scale_k14_Y}}
	rangeMaskPart.width			 	= 2
	rangeMaskPart.controllers	 	= {{"K14_movableSightLightness"}, {"K14_rotateRangeMask"}}
	rangeMaskPart.init_pos		 	= {0.0, 0.0, 0.0}
	rangeMaskPart.init_rot		 	= {angle - Ang_max_D / 1.5, 0.0, 0.0}
	rangeMaskPart.parent_element	= "2_mils_pipper"
	rangeMaskPart.isdraw			= true
	if not dbgDraw then
		rangeMaskPart.h_clip_relation 	= h_clip_relations.COMPARE
		rangeMaskPart.level				= HUD_DEFAULT_LEVEL + 1
	end
	rangeMaskPart.additive_alpha	= true
	rangeMaskPart.collimated		= true
	rangeMaskPart.use_mipfilter	 	= use_mipfilter
	Add(rangeMaskPart) 	
end

if not dbgDraw then
	addSpanMask("spanMaskClip_d", HUD_DEFAULT_LEVEL + 1, h_clip_relations.DECREASE_IF_LEVEL)
end

--[[
local dbgSightCircle	 			= CreateElement "ceSimpleLineObject"
dbgSightCircle.indices		 		= default_box_indices
dbgSightCircle.material		 		= "INDICATION_K14"
dbgSightCircle.name			 		= "dbgSightCircle"
dbgSightCircle.tex_params 	 		= {{tex_units_k14_X * 305, tex_units_k14_Y * 54}, {tex_units_k14_X * 305, tex_units_k14_Y * 488},
	{tex_scale_k14_X, tex_scale_k14_Y}}
dbgSightCircle.width			 	= 2
dbgSightCircle.controllers	 		= {{"K14_dbgSightCircle"}}
dbgSightCircle.init_pos		 		= {0, 0, 0}
dbgSightCircle.init_rot		 		= {0, 0, 0}
dbgSightCircle.parent_element		= "2_mils_pipper"
dbgSightCircle.isdraw				= true
dbgSightCircle.additive_alpha		= true
dbgSightCircle.collimated			= true
dbgSightCircle.use_mipfilter	 	= use_mipfilter
Add(dbgSightCircle)
--]]

flag_draw_grid = dbgDraw

-- reference grid
if flag_draw_grid then

	--[[
	local circle100 = CreateElement "ceMeshPoly"
		circle100.primitivetype = "triangles"
		set_circle(circle100,100,101)
		circle100.material   = "DBG_GREEN"
		circle100.collimated = true
		circle100.parent_element = "2_mils_pipper"
		Add(circle100)
	--]]
	
	local circle60 = CreateElement "ceMeshPoly"
		circle60.primitivetype = "triangles"
		set_circle(circle60, 60, 59)
		circle60.material   = "DBG_GREEN"
		circle60.collimated = true
		circle60.parent_element = "2_mils_pipper"
		Add(circle60)
		
	--[[
	local circle625 = CreateElement "ceMeshPoly"
		circle625.primitivetype = "triangles"
		set_circle(circle625,6.25,7.25)
		circle625.material   = "DBG_GREEN"
		circle625.collimated = true
		circle625.parent_element = "2_mils_pipper"
		Add(circle625)
		
	local circle0 = CreateElement "ceMeshPoly"
		circle0.primitivetype = "triangles"
		set_circle(circle0,25,26)
		circle0.material   = "DBG_GREEN"
		circle0.collimated = true
		circle0.parent_element = "2_mils_pipper"
		Add(circle0)
	--]]
	
	--[[
	local circle35 = CreateElement "ceMeshPoly"
		circle35.primitivetype = "triangles"
		set_circle(circle35, 35, 34)
		circle35.material   = "DBG_GREEN"
		circle35.collimated = true
		circle35.parent_element = "2_mils_pipper"
		Add(circle35)
	--]]
end
---------
